/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DarknessModifier
extends Modifier
implements TooltipModifierHook,
BreakSpeedModifierHook,
MeleeDamageModifierHook,
ConditionalStatModifierHook {
    public static int getLight(Level world, BlockPos pos) {
        return Math.max(world.m_45517_(LightLayer.SKY, pos) - world.m_7445_(), world.m_45517_(LightLayer.BLOCK, pos));
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOLTIP, ModifierHooks.BREAK_SPEED, ModifierHooks.MELEE_DAMAGE, ModifierHooks.CONDITIONAL_STAT});
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        BlockPos pos;
        int light;
        Player player = event.getEntity();
        Level world = player.m_20193_();
        if (event.getPosition().isPresent() && (light = DarknessModifier.getLight(world, pos = ((BlockPos)event.getPosition().get()).m_7494_()) + 1) < 10) {
            event.setNewSpeed((float)((double)event.getNewSpeed() * (1.0 + 0.5 * (double)modifier.getLevel() / (double)light)));
        }
    }

    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        BlockPos pos;
        Level world;
        int light;
        Player player = context.getPlayerAttacker();
        if (player != null && (light = DarknessModifier.getLight(world = player.m_20193_(), pos = player.m_20097_().m_7494_()) + 1) < 10) {
            return (float)((double)damage * (1.0 + 0.5 * (double)modifier.getLevel() / (double)light));
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Level world = living.m_20193_();
        int level = modifier.getLevel();
        BlockPos pos = living.m_20097_().m_7494_();
        int light = DarknessModifier.getLight(world, pos) + 1;
        if (light < 10 && stat == ToolStats.DRAW_SPEED) {
            return (float)((double)baseValue * (1.0 + 0.5 * (double)level / (double)light));
        }
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (player != null && (harvest || tool.hasTag(TinkerTags.Items.RANGED)) && tooltipKey == TooltipKey.SHIFT) {
            if (harvest) {
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.darkness.attack_damage"), (double)(0.5 * (double)modifier.getLevel()), tooltip);
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.darkness.mining_speed"), (double)(0.5 * (double)modifier.getLevel()), tooltip);
            } else {
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.darkness.draw_speed"), (double)(0.5 * (double)modifier.getLevel()), tooltip);
            }
        }
    }
}

